/*
Macro_scripts for UVW Unwrap

Version: 3dsmax 9



Revision History:
		
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		moved functions and dialog definition into the /stdplug/stdscripts/modifier_uvwunwrap_dialog.ms
	
	28th august 2006, Pierre-Felix Breton
		minor updates to actions

*/




macroScript OpenUnwrapUI
	category:~OPENUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~OPENUNWRAPUI_TOOLTIP~		
	silentErrors:TRUE

	
(

  unwrapModPKW = modpanel.getcurrentobject()
  xPKW =  unwrapModPKW.GetWindowX()
  yPKW =  unwrapModPKW.GetWindowY()
  hPKW =  unwrapModPKW.GetWindowH()
  if (hPKW==0) then
  	(
	yPKW = -10
	)  
  pPKW = Point2 xPKW (yPKW+hPKW)
  CreateDialog UnwrapUIDialog pos:pPKW style:#(#style_border)
  
  if (hPKW==0) then
  	(
	unwrapUIdialog.height = 0 
	)
  
)


macroScript MoveUnwrapUI
	category:~MOVEUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~MOVEUNWRAPUI_TOOLTIP~	
	silentErrors:TRUE

	
(
  unwrapModPKW = modpanel.getcurrentobject()
  xPKW = unwrapModPKW .GetWindowX()
  yPKW = unwrapModPKW .GetWindowY()
  hPKW = unwrapModPKW .GetWindowH()
  
  if (hPKW==0) then  
  	(
	yPKW = -10
	)

  pPKW = Point2 xPKW (yPKW+hPKW)
  SetDialogPos UnwrapUIDialog pPKW
    
  if (hPKW==0) then
  	(
	unwrapUIdialog.height = 0 
	)
   else
    (
	if 	(UnwrapUIDialog.dash_options.state==TRUE) then
		(
		if (unwrapUIdialog.height != 163 ) then
			unwrapUIdialog.height = 163  
		)
	else 
		(
		if (unwrapUIdialog.height != 78 ) then
			unwrapUIdialog.height = 78  
		)
	unwrapUIdialog.UpdateUI()
	)
)


macroScript CloseUnwrapUI
	category:~CLOSEUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~CLOSEUNWRAPUI_TOOLTIP~
	silentErrors:TRUE

	
(
  DestroyDialog UnwrapUIDialog
)


-----------------------------------------------------

macroScript UVWUnwrap_Stitch
	category:~UVWUNWRAP_STITCH_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_STITCH_TOOLTIP~
	buttontext:~UVWUNWRAP_STITCH_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40043"  -- All Commands: Stitch
	on altExecute type do actionMan.executeAction 2077580866 "40044"  -- All Commands: Stitch Dialog	
)

macroScript UVWUnwrap_Sketch
	category:~UVWUNWRAP_SKETCH_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_SKETCH_TOOLTIP~
	buttontext:~UVWUNWRAP_SKETCH_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40114"  -- All Commands: Sketch
	on altExecute type do actionMan.executeAction 2077580866 "40112"  -- All Commands: Sketch Dialog
)

macroScript UVWUnwrap_Pack
	category:~UVWUNWRAP_PACK_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_PACK_TOOLTIP~
	buttontext:~UVWUNWRAP_PACK_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40074"  -- All Commands: Pack
	on altExecute type do actionMan.executeAction 2077580866 "40075"  -- All Commands: Pack Dialog
)

macroScript UVWUnwrap_Relax
	category:~UVWUNWRAP_RELAX_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_RELAX_TOOLTIP~
	buttontext:~UVWUNWRAP_RELAX_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40135"  -- All Commands: Relax
	on altExecute type do actionMan.executeAction 2077580866 "40136"  -- All Commands: Relax Dialog
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAMumlOo1DrcuonCoZXYyCMeTprb+EPOp65
-- JiJOVqbDrpyC91r/mNabE6jwyc4Uv5O55tdp1x6X8OwqofZzkFP0kvuvs1Pt8DvC
-- gv00kTq8IUOX96cH9w3OQMUSTaePlihnWMYt4YGw5VEY9m3D5M/5sDEJaF3HXCdp
-- WuD1jfRV6KnLvlgEnFKbykYMVmcj3dWGFgLj79DWVGMbgl5nsZwtS1hQQ98m6HlU
-- lQ+xWZfGZ77rmEagvQSxMUUMUTHcrtimWXBBmGBlZFweBxcsdyB+K+VPxu3M16Pj
-- dI7U4nYK5LiRm4RuX6YBkM+HQqzzC24cZz8yVgSCoiDVjhi2MjQM
-- -----END-SIGNATURE-----